
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ferris_wheel")

# Create variables
premium = m.addVar(lb=0, vtype=GRB.INTEGER, name="premium")
regular = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular")


# Set objective function
m.setObjective(50 * premium + 30 * regular, GRB.MAXIMIZE)

# Add constraints
m.addConstr(premium + regular <= 250, "capacity")
m.addConstr(premium >= 50, "min_premium")
m.addConstr(regular >= 3 * premium, "regular_preference")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of premium tickets: {premium.x}")
    print(f"Number of regular tickets: {regular.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

