
import gurobipy as gp

# Create a new model
m = gp.Model("FerrisWheel")

# Define variables
x1 = m.addVar(name="premium_tickets", lb=0, vtype=gp.GRB.INTEGER)  # Number of premium tickets
x2 = m.addVar(name="regular_tickets", lb=0, vtype=gp.GRB.INTEGER)  # Number of regular tickets

# Objective function: Maximize profit
m.setObjective(50*x1 + 30*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 250, name="capacity_constraint")  # Total tickets do not exceed 250
m.addConstr(x1 >= 50, name="premium_min_constraint")  # Minimum of 50 premium tickets
m.addConstr(x2 >= 3*x1, name="regular_vs_premium_constraint")  # Regular tickets are at least 3 times premium tickets

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Premium Tickets: {x1.varValue}")
    print(f"Regular Tickets: {x2.varValue}")
    print(f"Max Profit: {50*x1.varValue + 30*x2.varValue}")
else:
    print("No optimal solution found.")
