
import gurobipy as gp

# Create a new model
model = gp.Model("Apple Pie Filling")

# Create variables
green_apples = model.addVar(lb=0, name="green_apples")  # kg of green apples
red_apples = model.addVar(lb=0, name="red_apples")  # kg of red apples

# Set objective function: Minimize cost
model.setObjective(9 * green_apples + 7 * red_apples, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.05 * green_apples + 0.25 * red_apples >= 12, "sugar_constraint")
model.addConstr(0.16 * green_apples + 0.08 * red_apples >= 5, "fiber_constraint")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${model.objVal:.2f}")
    print(f"Green apples: {green_apples.x:.2f} kg")
    print(f"Red apples: {red_apples.x:.2f} kg")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

