
from gurobipy import *

# Create a new model
m = Model("Pie_Filling")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="green_apples", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="red_apples", lb=0)

# Set the objective function
m.setObjective(9*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.05*x1 + 0.25*x2 >= 12, "sugar_constraint")
m.addConstr(0.16*x1 + 0.08*x2 >= 5, "fiber_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Green apples: {x1.x} kg")
    print(f"Red apples: {x2.x} kg")
    print(f"Minimum cost: ${m.objVal}")
else:
    print("No optimal solution found")

