
import gurobi

def solve_pie_filling_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="green_apples", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="red_apples", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize cost
    model.setObjective(9 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.05 * x1 + 0.25 * x2 >= 12, name="min_sugar")
    model.addConstr(0.16 * x1 + 0.08 * x2 >= 5, name="min_fiber")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of green apples: {x1.varValue} kg")
        print(f"Optimal amount of red apples: {x2.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_pie_filling_problem()
