
import gurobipy as gp

# Create a new model
m = gp.Model("lunch_optimization")

# Create variables
meat = m.addVar(vtype=gp.GRB.CONTINUOUS, name="meat")  # Number of meat lunches
veggie = m.addVar(vtype=gp.GRB.CONTINUOUS, name="veggie") # Number of veggie lunches

# Set objective function
m.setObjective(8 * meat + 6 * veggie, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * meat + 4 * veggie <= 500, "prep_time") # Prep time constraint
m.addConstr(3 * meat + 5 * veggie <= 400, "package_time") # Packaging time constraint
m.addConstr(meat >= 0, "meat_nonneg") # Non-negativity constraint
m.addConstr(veggie >= 0, "veggie_nonneg") # Non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of meat lunches: {meat.x}")
    print(f"Number of veggie lunches: {veggie.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

