
from gurobipy import *

# Create a new model
model = Model("Diner_Problem")

# Define variables
x1 = model.addVar(name="meat_lunches", vtype=GRB.CONTINUOUS, lb=0)
x2 = model.addVar(name="veggie_lunches", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
model.setObjective(8*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 4*x2 <= 500, name="preparation_time")
model.addConstr(3*x1 + 5*x2 <= 400, name="packaging_time")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
