
import gurobipy as gp

# Create a new model
model = gp.Model("Lunch_Preparation")

# Define variables
x1 = model.addVar(name="meat_lunches", lb=0, vtype=gp.GRB.INTEGER)  # Number of meat lunches
x2 = model.addVar(name="veggie_lunches", lb=0, vtype=gp.GRB.INTEGER)  # Number of veggie lunches

# Objective function: Maximize profit
model.setObjective(8*x1 + 6*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(5*x1 + 4*x2 <= 500, name="prep_time")  # Preparation time constraint
model.addConstr(3*x1 + 5*x2 <= 400, name="packaging_time")  # Packaging time constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.x[0]} meat lunches, {model.x[1]} veggie lunches")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found")
