
import gurobipy as gp

# Create a new model
m = gp.Model("Nolan's Farm Allocation")

# Create variables
pumpkins = m.addVar(name="pumpkins")  # Acres of pumpkins
potatoes = m.addVar(name="potatoes")  # Acres of potatoes

# Set objective function
m.setObjective(150 * pumpkins + 200 * potatoes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5 * pumpkins + 0.9 * potatoes <= 12, "Tractor")
m.addConstr(0.6 * pumpkins + 0.5 * potatoes <= 12, "Plow")
m.addConstr(0.4 * pumpkins + 0.3 * potatoes <= 12, "Combine")
m.addConstr(pumpkins >=0)
m.addConstr(potatoes >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Acres of Pumpkins: {pumpkins.x:.2f}")
    print(f"Acres of Potatoes: {potatoes.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

