
from gurobipy import *

# Create a new model
m = Model("Nolan_Farming")

# Add variables to the model
x_p = m.addVar(lb=0, name="acres_of_pumpkins")
x_t = m.addVar(lb=0, name="acres_of_potatoes")

# Set the objective function
m.setObjective(150*x_p + 200*x_t, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(0.5*x_p + 0.9*x_t <= 12, "Tractor_Constraint")
m.addConstr(0.6*x_p + 0.5*x_t <= 12, "Plow_Constraint")
m.addConstr(0.4*x_p + 0.3*x_t <= 12, "Combine_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal acres of pumpkins: {x_p.x}")
    print(f"Optimal acres of potatoes: {x_t.x}")
    print(f"Maximum revenue: {m.objVal}")
else:
    print("No optimal solution found")
