
import gurobi

def solve_farming_equipment_allocation():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="pumpkin_acres", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="potato_acres", lb=0, ub=gurobi.GRB.INFINITY)

    # Set objective function
    model.setObjective(150 * x1 + 200 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.5 * x1 + 0.9 * x2 <= 12, name="tractor_constraint")
    model.addConstr(0.6 * x1 + 0.5 * x2 <= 12, name="plow_constraint")
    model.addConstr(0.4 * x1 + 0.3 * x2 <= 12, name="combine_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of pumpkins: {x1.varValue}")
        print(f"Acres of potatoes: {x2.varValue}")
        print(f"Max revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_farming_equipment_allocation()
