
import gurobipy as gp

# Create a new model
m = gp.Model("network_design")

# Create variables
star = m.addVar(vtype=gp.GRB.INTEGER, name="star")
circle = m.addVar(vtype=gp.GRB.INTEGER, name="circle")
snowflake = m.addVar(vtype=gp.GRB.INTEGER, name="snowflake")


# Set objective function
m.setObjective(2231 * star + 3434 * circle + 8621 * snowflake, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(40 * star + 20 * circle + 323 * snowflake <= 3000, "workstations")
m.addConstr(10 * star + 12 * circle + 122 * snowflake <= 400, "servers")
m.addConstr(2 * star + 5 * circle + 41 * snowflake <= 200, "switches")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Maximum profit: ${m.objVal}")
    print(f"Star layouts: {star.x}")
    print(f"Circle layouts: {circle.x}")
    print(f"Snowflake layouts: {snowflake.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

