
import gurobipy as gp

# Create a new model
m = gp.Model("layout_optimization")

# Define variables
x1 = m.addVar(name="star_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of star layouts
x2 = m.addVar(name="circle_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of circle layouts
x3 = m.addVar(name="snowflake_layouts", lb=0, vtype=gp.GRB.INTEGER)  # Number of snowflake layouts

# Objective function: maximize profit
m.setObjective(2231*x1 + 3434*x2 + 8621*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(40*x1 + 20*x2 + 323*x3 <= 3000, name="workstations")  # Workstations constraint
m.addConstr(10*x1 + 12*x2 + 122*x3 <= 400, name="servers")  # Servers constraint
m.addConstr(2*x1 + 5*x2 + 41*x3 <= 200, name="switches")  # Switches constraint

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Star Layouts: {x1.varValue}")
    print(f"Circle Layouts: {x2.varValue}")
    print(f"Snowflake Layouts: {x3.varValue}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
