
import gurobipy as gp

# Create a new model
model = gp.Model("Detergent Production")

# Create variables
fruity_loop = model.addVar(lb=0, name="Fruity_Loop")  # x1
passion_cook = model.addVar(lb=0, name="Passion_Cook") # x2

# Set objective function
model.setObjective(6 * fruity_loop + 5 * passion_cook, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.1 * fruity_loop + 0.05 * passion_cook >= 20, "Soap_Constraint")
model.addConstr(0.06 * fruity_loop + 0.1 * passion_cook >= 15, "Citric_Acid_Constraint")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Fruity Loop Production: {fruity_loop.x:.2f} kg")
    print(f"Passion Cook Production: {passion_cook.x:.2f} kg")

