
from gurobipy import *

# Create a new model
m = Model("Detergent_Production")

# Define variables
x1 = m.addVar(name="Fruity_Loop", lb=0)
x2 = m.addVar(name="Passion_Cook", lb=0)

# Set the objective function
m.setObjective(6*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x1 + 0.05*x2 >= 20, name="Soap_Constraint")
m.addConstr(0.06*x1 + 0.10*x2 >= 15, name="Citric_Acid_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fruity Loop: {x1.x} kg")
    print(f"Passion Cook: {x2.x} kg")
    print(f"Total Cost: ${6*x1.x + 5*x2.x}")
else:
    print("No optimal solution found")
