
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Fruity_Loop", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Passion_Cook", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(6 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(0.10 * x1 + 0.05 * x2 >= 20, name="soap_constraint")
    model.addConstr(0.06 * x1 + 0.10 * x2 >= 15, name="citric_acid_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Fruity Loop: {x1.varValue} kg")
        print(f"Passion Cook: {x2.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_problem()
