
from gurobipy import *

# Create a new model
m = Model("Shipping_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="shipping_containers")
x2 = m.addVar(vtype=GRB.INTEGER, name="cargo_planes")

# Set the objective function
m.setObjective(1000*x1 + 800*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000*x1 + 6000*x2 <= 20000, "budget_constraint")
m.addConstr(x1 <= x2, "shipping_delay_constraint")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shipping Containers: {x1.x}")
    print(f"Cargo Planes: {x2.x}")
    print(f"Total Products Sent: {1000*x1.x + 800*x2.x}")
else:
    print("No optimal solution found")
