
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=None, obj=0)  # Number of shipping containers
    x2 = model.addVar(name="x2", lb=0, ub=None, obj=0)  # Number of cargo planes

    # Set the objective function coefficients
    x1.obj = 1000
    x2.obj = 800

    # Add constraints
    model.addConstr(5000 * x1 + 6000 * x2 <= 20000, name="budget_constraint")
    model.addConstr(x1 <= x2, name="container_plane_constraint")

    # Set the model to maximize the objective function
    model.modelSense = gurobi.GRB.MAXIMIZE

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of shipping containers: {x1.x}")
        print(f"Number of cargo planes: {x2.x}")
        print(f"Total products sent: {1000*x1.x + 800*x2.x}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
