
import gurobipy as gp

# Create a new model
m = gp.Model("knitting_problem")

# Create variables
toques = m.addVar(vtype=gp.GRB.INTEGER, name="toques")
scarfs = m.addVar(vtype=gp.GRB.INTEGER, name="scarfs")

# Set objective function
m.setObjective(5 * toques + 7 * scarfs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * toques + 5 * scarfs <= 200, "yarn_constraint")
m.addConstr(30 * toques + 40 * scarfs <= 1800, "time_constraint")
m.addConstr(toques >= 0, "toques_nonnegative")
m.addConstr(scarfs >= 0, "scarfs_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of toques to knit: {toques.x}")
    print(f"Number of scarfs to knit: {scarfs.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

