
from gurobipy import *

# Create a new model
model = Model("Knitting_Optimization")

# Define the variables
x1 = model.addVar(vtype=GRB.INTEGER, name="toques")
x2 = model.addVar(vtype=GRB.INTEGER, name="scarves")

# Set the objective function: Maximize profit
model.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x1 + 5*x2 <= 200, "yarn_constraint")
model.addConstr(30*x1 + 40*x2 <= 1800, "time_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
