
import gurobipy as gp

# Create a new model
model = gp.Model("Knitting_Problem")

# Define variables
x1 = model.addVar(name="toques", lb=0, vtype=gp.GRB.INTEGER)  # Number of toques
x2 = model.addVar(name="scarfs", lb=0, vtype=gp.GRB.INTEGER)  # Number of scarfs

# Objective function: Maximize profit
model.setObjective(5 * x1 + 7 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3 * x1 + 5 * x2 <= 200, name="yarn_constraint")  # Yarn constraint
model.addConstr(30 * x1 + 40 * x2 <= 1800, name="time_constraint")  # Time constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Toques = {x1.varValue}, Scarfs = {x2.varValue}")
    print(f"Maximum profit: ${5 * x1.varValue + 7 * x2.varValue}")
else:
    print("No optimal solution found.")
