
from gurobipy import Model, GRB

# Create a new model
m = Model("movie_theatre")

# Create variables
moving_seats = m.addVar(vtype=GRB.INTEGER, name="moving_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(15 * moving_seats + 10 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(moving_seats + regular_seats <= 100, "capacity")
m.addConstr(moving_seats >= 15, "min_moving")
m.addConstr(regular_seats >= 3 * moving_seats, "preference")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Number of moving seats to sell: {moving_seats.x}")
    print(f"Number of regular seats to sell: {regular_seats.x}")
    print(f"Maximum profit: ${m.objVal}")

