
from gurobipy import *

# Create a new model
m = Model("Movie_Theatre_Profit")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="moving_seat_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_seat_tickets")

# Set the objective function
m.setObjective(15*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_seats")
m.addConstr(x1 >= 15, "minimum_moving_seats")
m.addConstr(x2 >= 3*x1, "regular_vs_moving_seats")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Moving seat tickets: {x1.x}")
    print(f"Regular seat tickets: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
