
import gurobi

def solve_movie_theatre_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="moving_seats")  # Number of moving seat tickets
    x2 = model.addVar(lb=0, name="regular_seats")  # Number of regular seat tickets

    # Objective function: maximize 15*x1 + 10*x2
    model.setObjective(15*x1 + 10*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_seats")
    model.addConstr(x1 >= 15, name="min_moving_seats")
    model.addConstr(x2 >= 3*x1, name="regular_vs_moving")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Moving seat tickets: {x1.varValue}")
        print(f"Regular seat tickets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_movie_theatre_problem()
