
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ad_placement")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="airport_ads")
x2 = m.addVar(vtype=GRB.INTEGER, name="mall_ads")
x3 = m.addVar(vtype=GRB.INTEGER, name="theatre_ads")

# Set objective function
m.setObjective(100000*x1 + 40000*x2 + 10000*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10000*x1 + 3000*x2 + 2000*x3 <= 100000, "budget")
m.addConstr(x1 <= 5, "airport_limit")
m.addConstr(x3 <= 0.5*(x1 + x2 + x3), "theatre_proportion")
m.addConstr(x2 >= 0.3*(x1 + x2 + x3), "mall_proportion")
m.addConstr(x1 >= 0, "airport_nonneg")
m.addConstr(x2 >= 0, "mall_nonneg")
m.addConstr(x3 >= 0, "theatre_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Viewership: {m.objVal}")
    print(f"Airport Ads: {x1.x}")
    print(f"Mall Ads: {x2.x}")
    print(f"Theatre Ads: {x3.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

