
import gurobi

def solve_ads_optimization():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="x1")  # ads in airports
    x2 = model.addVar(lb=0, name="x2")  # ads in malls
    x3 = model.addVar(lb=0, name="x3")  # ads in movie theatres

    # Objective function: maximize viewership
    model.setObjective(100000*x1 + 40000*x2 + 10000*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 <= 5, name="airport_limit")
    model.addConstr(x3 <= x1 + x2, name="movie_theatre_limit")
    model.addConstr(x2 >= 0.3*(x1 + x2 + x3), name="mall_percentage")
    model.addConstr(10000*x1 + 3000*x2 + 2000*x3 <= 100000, name="budget")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ads in airports: {x1.varValue}")
        print(f"Ads in malls: {x2.varValue}")
        print(f"Ads in movie theatres: {x3.varValue}")
        print(f"Max viewership: {model.objVal}")
    else:
        print("The model is infeasible")

solve_ads_optimization()
