
from gurobipy import Model, GRB

# Create a new model
model = Model("Matter Auto Advertising")

# Create decision variables
sports_ads = model.addVar(vtype=GRB.CONTINUOUS, name="sports_ads")
tv_show_ads = model.addVar(vtype=GRB.CONTINUOUS, name="tv_show_ads")


# Set objective function
model.setObjective(90000 * sports_ads + 20000 * tv_show_ads, GRB.MINIMIZE)

# Add constraints
model.addConstr(4000000 * sports_ads + 12000000 * tv_show_ads >= 40000000, "Baby Boomers Reach")
model.addConstr(18000000 * sports_ads + 5000000 * tv_show_ads >= 25000000, "Millennials Reach")
model.addConstr(sports_ads >=0)
model.addConstr(tv_show_ads >=0)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal}")
    print(f"Number of sports ads: {sports_ads.x}")
    print(f"Number of TV show ads: {tv_show_ads.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

