
from gurobipy import *

# Create a new model
m = Model("Matter_Auto_Advertising")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sports_ad_commercials", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="tv_show_commercials", lb=0)

# Set the objective function
m.setObjective(90000*x1 + 20000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 12*x2 >= 40000000, name="baby_boomers_constraint")
m.addConstr(18*x1 + 5*x2 >= 25000000, name="millennials_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of sports ad commercials: {x1.x}")
    print(f"Number of TV show commercials: {x2.x}")
    print(f"Total cost: ${90000*x1.x + 20000*x2.x:.2f}")
else:
    print("No optimal solution found.")

