
import gurobipy as gp

# Create a new model
model = gp.Model("Matter_Auto_Advertising")

# Define the variables
x1 = model.addVar(name="sports_ads", lb=0, vtype=gp.GRB.INTEGER)  # Number of sports ads
x2 = model.addVar(name="tv_show_commercials", lb=0, vtype=gp.GRB.INTEGER)  # Number of TV show commercials

# Define the objective function
model.setObjective(90000 * x1 + 20000 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x1 + 12 * x2 >= 40, name="baby_boomers_constraint")  # Baby boomers constraint
model.addConstr(18 * x1 + 5 * x2 >= 25, name="millennials_constraint")  # Millennials constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Number of sports ads: {x1.varValue}")
    print(f"Number of TV show commercials: {x2.varValue}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
