
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Bouquets")

# Create variables
daisies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daisies") # Number of daisy bouquets
lilies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lilies")   # Number of lily bouquets


# Set objective function
m.setObjective(5 * daisies + 4 * lilies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * daisies + lilies <= 1000, "Clipping_Time")
m.addConstr(2 * daisies + 3 * lilies <= 650, "Packaging_Time")
m.addConstr(daisies >= 25, "Min_Daisies")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of daisy bouquets: {daisies.x:.2f}")
    print(f"Number of lily bouquets: {lilies.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

