
import gurobi

def solve_garden_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=25, name="daisies")  # At least 25 bouquets of daisies
    x2 = model.addVar(lb=0, name="lilies")   # Non-negative bouquets of lilies

    # Define the objective function
    model.setObjective(5 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + x2 <= 1000, name="clipping_time")
    model.addConstr(2 * x1 + 3 * x2 <= 650, name="packaging_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Number of bouquets of daisies: {x1.varValue}")
        print(f"Number of bouquets of lilies: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_garden_problem()
