
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_repair")

# Create variables
phones = m.addVar(vtype=GRB.INTEGER, name="phones")
laptops = m.addVar(vtype=GRB.INTEGER, name="laptops")

# Set objective function
m.setObjective(50 * phones + 60 * laptops, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * phones + 30 * laptops <= 6000, "inspection_constraint")
m.addConstr(30 * phones + 50 * laptops <= 7000, "fixing_constraint")
m.addConstr(phones >= 0, "phones_nonnegative")
m.addConstr(laptops >= 0, "laptops_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of phones to repair: {phones.x}")
    print(f"Number of laptops to repair: {laptops.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

