
import gurobipy as gp

# Create a new model
model = gp.Model("electronics_repair")

# Define the variables
x1 = model.addVar(name="phones", lb=0, vtype=gp.GRB.INTEGER)  # Number of phones
x2 = model.addVar(name="laptops", lb=0, vtype=gp.GRB.INTEGER)  # Number of laptops

# Define the objective function
model.setObjective(50*x1 + 60*x2, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(20*x1 + 30*x2 <= 6000, name="inspection_time")
model.addConstr(30*x1 + 50*x2 <= 7000, name="fixing_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: phones = {x1.varValue}, laptops = {x2.varValue}")
    print(f"Maximum profit: ${50*x1.varValue + 60*x2.varValue}")
else:
    print("The model is infeasible")
