
import gurobipy as gp

# Create a new model
m = gp.Model("Cosmetics_Production")

# Create variables
low = m.addVar(vtype=gp.GRB.CONTINUOUS, name="low")  # Low quality face wash
medium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="medium") # Medium quality face wash
high = m.addVar(vtype=gp.GRB.CONTINUOUS, name="high") # High quality face wash


# Set objective function
m.setObjective(3 * low + 7 * medium + 9 * high, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * low + 3 * medium + 4 * high <= 100, "rare_ingredients")
m.addConstr(4 * low + 2 * medium + 1 * high <= 200, "water")
m.addConstr(low >= 0, "low_nonneg")
m.addConstr(medium >= 0, "med_nonneg")
m.addConstr(high >= 0, "high_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Low quality face wash: {low.x}")
    print(f"Medium quality face wash: {medium.x}")
    print(f"High quality face wash: {high.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

