
from gurobipy import *

# Create a model
m = Model("FaceWashProduction")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="low_quality")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="medium_quality")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="high_quality")

# Set the objective function
m.setObjective(3*x1 + 7*x2 + 9*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 + 4*x3 <= 100, "rare_ingredients")
m.addConstr(4*x1 + 2*x2 + x3 <= 200, "water")

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
