
import gurobipy as gp

# Create a new model
model = gp.Model("FaceWashProduction")

# Define variables
x1 = model.addVar(name="low_quality", lb=0, vtype=gp.GRB.CONTINUOUS)  # low quality face wash
x2 = model.addVar(name="medium_quality", lb=0, vtype=gp.GRB.CONTINUOUS)  # medium quality face wash
x3 = model.addVar(name="high_quality", lb=0, vtype=gp.GRB.CONTINUOUS)  # high quality face wash

# Objective function: Maximize profits
model.setObjective(3*x1 + 7*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + 3*x2 + 4*x3 <= 100, name="rare_ingredients_constraint")
model.addConstr(4*x1 + 2*x2 + x3 <= 200, name="water_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Low Quality Face Wash: {x1.varValue}")
    print(f"Medium Quality Face Wash: {x2.varValue}")
    print(f"High Quality Face Wash: {x3.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
