
import gurobipy as gp

# Create a new model
m = gp.Model("meal_optimization")

# Create variables
vegetarian = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vegetarian")
meat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="meat")


# Set objective function
m.setObjective(4 * vegetarian + 6 * meat, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * vegetarian + 30 * meat >= 100, "protein_req")
m.addConstr(20 * vegetarian + 15 * meat >= 150, "carb_req")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Eat {vegetarian.x} vegetarian meals and {meat.x} meat meals.")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

