
from gurobipy import *

# Create a model
m = Model("Meal_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vegetarian_meals")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="meat_meals")

# Set the objective function
m.setObjective(4*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 30*x2 >= 100, "protein_constraint")
m.addConstr(20*x1 + 15*x2 >= 150, "carbs_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of vegetarian meals: {x1.x}")
    print(f"Number of meat meals: {x2.x}")
    print(f"Total cost: ${4*x1.x + 6*x2.x:.2f}")
else:
    print("No optimal solution found")
