
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="vegetarian_meals", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="meat_meals", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(4 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(10 * x1 + 30 * x2 >= 100, name="protein_requirement")
    model.addConstr(20 * x1 + 15 * x2 >= 150, name="carb_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vegetarian meals: {x1.varValue}")
        print(f"Meat meals: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
