
import gurobipy as gp

# Create a new model
m = gp.Model("Cacaotier_Optimization")

# Create variables
truffles = m.addVar(vtype=gp.GRB.INTEGER, name="truffles")
bars = m.addVar(vtype=gp.GRB.INTEGER, name="bars")

# Set objective function
m.setObjective(7 * truffles + 3 * bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(700 * truffles + 300 * bars <= 30000, "Cocoa_Constraint")
m.addConstr(bars >= 2 * truffles, "Demand_Constraint")
m.addConstr(truffles >= 10, "Minimum_Truffles")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of truffles: {truffles.x}")
    print(f"Number of chocolate bars: {bars.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

