
from gurobipy import *

# Create a new model
m = Model("Cacaotier_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="gourmet_truffles")
x2 = m.addVar(vtype=GRB.INTEGER, name="chocolate_bars")

# Set the objective function
m.setObjective(7*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(700*x1 + 300*x2 <= 30000, "cocoa_availability")
m.addConstr(x1 >= 10, "min_gourmet_truffles")
m.addConstr(x2 >= 2*x1, "chocolate_bars_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of gourmet truffles: {x1.x}")
    print(f"Number of chocolate bars: {x2.x}")
    print(f"Maximum profit: ${7*x1.x + 3*x2.x}")
else:
    print("No optimal solution found")
