
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="x1")  # Gourmet truffles
    x2 = model.addVar(lb=0, name="x2")  # Chocolate bars

    # Objective function: Maximize 7*x1 + 3*x2
    model.setObjective(7 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(700 * x1 + 300 * x2 <= 30000, name="cocoa_constraint")
    model.addConstr(x2 >= 2 * x1, name="ratio_constraint")
    model.addConstr(x1 >= 10, name="min_truffles_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Gourmet truffles: {x1.varValue}")
        print(f"Chocolate bars: {x2.varValue}")
        print(f"Maximum profit: {7 * x1.varValue + 3 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
