
import gurobipy as gp

# Create a new model
m = gp.Model("pie_shop")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # Number of regular pies
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # Number of premium pies


# Set objective function
m.setObjective(8*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 50, "demand_regular")
m.addConstr(x2 <= 30, "demand_premium")
m.addConstr(x1 + x2 <= 60, "total_pies")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular pies (x1): {x1.x}")
    print(f"Number of premium pies (x2): {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

