
from gurobipy import *

# Create a new model
m = Model("Pie_Shop_Optimization")

# Add variables
x1 = m.addVar(name="regular_pies", lb=0)  # Number of regular pies
x2 = m.addVar(name="premium_pies", lb=0)  # Number of premium pies

# Set the objective function: Maximize profit
m.setObjective(8*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 50, name="regular_pie_demand")  # Demand constraint for regular pies
m.addConstr(x2 <= 30, name="premium_pie_demand")  # Demand constraint for premium pies
m.addConstr(x1 + x2 <= 60, name="total_production_capacity")  # Total production capacity

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular pies: {x1.x}")
    print(f"Number of premium pies: {x2.x}")
    print(f"Maximum profit: ${8*x1.x + 10*x2.x:.2f}")
else:
    print("No optimal solution found")
