
import gurobipy as gp

# Create a new model
model = gp.Model("PieShop")

# Define variables
x1 = model.addVar(lb=0, name="regular_pies")  # Number of regular pies
x2 = model.addVar(lb=0, name="premium_pies")  # Number of premium pies

# Objective function: Maximize profit
model.setObjective(8*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 50, name="regular_demand")
model.addConstr(x2 <= 30, name="premium_demand")
model.addConstr(x1 + x2 <= 60, name="total_pies")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${8*x1.varValue + 10*x2.varValue}")
else:
    print("No optimal solution found.")
