
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Keyboard Production")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="A400") # Number of A400 keyboards
x2 = m.addVar(vtype=GRB.INTEGER, name="P500") # Number of P500 keyboards


# Set objective function: Maximize profit
m.setObjective(35*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 3*x2, "Demand_Constraint") # Demand constraint
m.addConstr(5*x1 + 9*x2 <= 45, "Labor_Constraint") # Labor constraint
m.addConstr(x1 >= 0, "NonNegativity_x1")
m.addConstr(x2 >= 0, "NonNegativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of A400 keyboards: {x1.x}")
    print(f"Number of P500 keyboards: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

