
from gurobipy import *

# Create a new model
m = Model("Keyboard_Production")

# Add variables
x1 = m.addVar(lb=0, name="A400_Keyboards")
x2 = m.addVar(lb=0, name="P500_Keyboards")

# Set the objective function
m.setObjective(35*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 9*x2 <= 45, "Labour_Constraint")
m.addConstr(x1 >= 3*x2, "Demand_Forecast_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of A400 keyboards to produce: {x1.x}")
    print(f"Number of P500 keyboards to produce: {x2.x}")
    print(f"Maximum profit: ${35*x1.x + 80*x2.x:.2f}")
else:
    print("No optimal solution found.")
