
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="A400 keyboards", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="P500 keyboards", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 35*x1 + 80*x2
    model.setObjective(35*x1 + 80*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 9*x2 <= 45, name="labour_hours")
    model.addConstr(x1 >= 3*x2, name="production_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: A400 = {x1.varValue}, P500 = {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_optimization_problem()
