
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("pill_optimization")

    # Create variables
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Pill_A") # Number of Pill A
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Pill_B") # Number of Pill B


    # Set objective function
    m.setObjective(3*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x1 + 5*x2 >= 30, "Muscle_Relaxant")
    m.addConstr(3*x1 + x2 >= 15, "Anxiety_Medication")
    m.addConstr(4*x1 + 3*x2 >= 20, "Pain_Reliever")
    m.addConstr(x1 >= 0)
    m.addConstr(x2 >= 0)


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal cost: ${m.objVal:.2f}")
        print(f"Number of Pill A: {x1.x:.2f}")
        print(f"Number of Pill B: {x2.x:.2f}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
