
from gurobipy import *

# Create a new model
m = Model("Pill_Purchase")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="number_of_pills_A")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="number_of_pills_B")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 5*x2 >= 30, "muscle_relaxant")
m.addConstr(3*x1 + x2 >= 15, "anxiety_medication")
m.addConstr(4*x1 + 3*x2 >= 20, "pain_reliever")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pills A: {x1.x}")
    print(f"Number of pills B: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
